# Modify variables as appropriate for your environment. 

$SubscriptionId     ="00000000-0000-0000-0000000000000000000" # Get-AzSubscription PowerShell to obtain list of SubscriptionIds 
$ResourceGroup      ="myRG"         #edit with your ResourceGroup
$ServerName         ="myServerName" #edit with your ServerName
$RetentionInDays    ="90"           #edit with your retention policy
$StorageAccountBlob ="myBlobName"   #must already exist

$StorageAccountResourceId = "/subscriptions/$SubscriptionId/resourceGroups/$ResourceGroup/providers/Microsoft.Storage/storageAccounts/$StorageAccountBlob"

Set-AzSqlServerAudit -ResourceGroupName $ResourceGroup -ServerName $ServerName `
-BlobStorageTargetState Enabled `
-StorageAccountResourceId $StorageAccountResourceId `
-RetentionInDays $RetentionInDays `
-AuditActionGroup `
 APPLICATION_ROLE_CHANGE_PASSWORD_GROUP `
,BACKUP_RESTORE_GROUP `
,DATABASE_CHANGE_GROUP `
,DATABASE_LOGOUT_GROUP `
,DATABASE_OBJECT_CHANGE_GROUP `
,DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP `
,DATABASE_OBJECT_PERMISSION_CHANGE_GROUP `
,DATABASE_OPERATION_GROUP `
,DATABASE_OWNERSHIP_CHANGE_GROUP `
,DATABASE_PERMISSION_CHANGE_GROUP `
,DATABASE_PRINCIPAL_CHANGE_GROUP `
,DATABASE_PRINCIPAL_IMPERSONATION_GROUP `
,DATABASE_ROLE_MEMBER_CHANGE_GROUP `
,DBCC_GROUP `
,FAILED_DATABASE_AUTHENTICATION_GROUP `
,SCHEMA_OBJECT_CHANGE_GROUP `
,SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP `
,SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP `
,SCHEMA_OBJECT_ACCESS_GROUP `
,SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP `
,USER_CHANGE_PASSWORD_GROUP `
-PredicateExpression " NOT ( `
   (Statement LIKE 'select SERVERPROPERTY(%)')  `
OR (Statement LIKE 'SELECT @@SPID;'))"

$FormatEnumerationLimit   =-1
Get-AzSqlServerAudit -ResourceGroupName $ResourceGroup -ServerName $ServerName 
 